<?php
// Configurações de exibição de erros, úteis para o desenvolvimento
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Define a URL base para os assets
$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
// Obtém o nome da página atual
$current_page = basename($_SERVER['PHP_SELF']);

// Define a classe 'show' para o menu accordion, se a página 'themes.php' ou 'qr_url.php' estiver ativa
$accordion_active = ($current_page === 'themes.php' || $current_page === 'qr_url.php') ? 'show' : '';
?>

<div id="kt_app_sidebar" class="app-sidebar" data-kt-drawer="true" data-kt-drawer-name="app-sidebar"
    data-kt-drawer-activate="{default: true, lg: false}" data-kt-drawer-overlay="true" data-kt-drawer-width="250px"
    data-kt-drawer-direction="start" data-kt-drawer-toggle="#kt_app_sidebar_toggle">

    <div class="d-none d-lg-flex flex-center px-6 pt-10 pb-10" id="kt_app_sidebar_header">
        <a href="dns.php">
            <img alt="Logo" src="<?php echo $static_url; ?>media/logos/logo.png" class="h-50px" />
        </a>
    </div>

    <div class="flex-grow-1">
        <div id="kt_app_sidebar_menu_wrapper" class="hover-scroll-y" data-kt-scroll="true" data-kt-scroll-height="auto"
            data-kt-scroll-dependencies="#kt_app_sidebar_header" data-kt-scroll-offset="20px">

            <div class="app-sidebar-navs-default px-5 mb-10">
                <div id="#kt_app_sidebar_menu" data-kt-menu="true" data-kt-menu-expand="false"
                    class="menu menu-column menu-rounded menu-sub-indention">

                    <div class="separator mb-4 mx-4"></div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page === 'dns.php') ? 'active' : ''; ?>" href="dns.php">
                            <span class="menu-title">🌐 Adicionar DNS</span>
                        </a>
                    </div>
                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page === 'mac.php') ? 'active' : ''; ?>" href="mac.php">
                            <span class="menu-title">👥 Usuários Ativos</span>
                        </a>
                    </div>
                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page === 'note.php') ? 'active' : ''; ?>" href="note.php">
                            <span class="menu-title">📢 Mensagem Serv</span>
                        </a>
                    </div>

                    <div class="separator my-4 mx-4"></div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page === 'ads.php') ? 'active' : ''; ?>" href="ads.php">
                            <span class="menu-title">📤 Anuncio Banner</span>
                        </a>
                    </div>
                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page === 'modobanner.php') ? 'active' : ''; ?>" href="modobanner.php">
                            <span class="menu-title">⚙️ Modelo de Banner</span>
                        </a>
                    </div>

                    <div class="separator my-4 mx-4"></div>

                    <div data-kt-menu-trigger="click" class="menu-item <?php echo $accordion_active ? 'here ' . $accordion_active : ''; ?> menu-accordion">
                        <span class="menu-link py-2">
                            <span class="menu-title">🎨 Personalizar</span>
                            <span class="menu-arrow"></span>
                        </span>
                        <div class="menu-sub menu-sub-accordion">
                            <div class="menu-item">
                                <a class="menu-link <?php echo ($current_page === 'themes.php') ? 'active' : ''; ?>" href="themes.php">
                                    <span class="menu-bullet">
                                        <span class="bullet bullet-dot"></span>
                                    </span>
                                    <span class="menu-title">🎭 Temas Aplicativo</span>
                                </a>
                            </div>
                            <div class="menu-item">
                                <a class="menu-link <?php echo ($current_page === 'qr_url.php') ? 'active' : ''; ?>" href="qr_url.php">
                                    <span class="menu-bullet">
                                        <span class="bullet bullet-dot"></span>
                                    </span>
                                    <span class="menu-title">🧾 QR Code</span>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="separator my-4 mx-4"></div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page === 'users.php') ? 'active' : ''; ?>" href="users.php">
                            <span class="menu-title">👤 Meu Perfil</span>
                        </a>
                    </div>
                </div>
            </div>
            </div>
    </div>
</div>