<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// Define a URL base para os assets estáticos
$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';

// O título da página pode ser definido antes de incluir este arquivo,
// caso contrário, um título padrão será usado.
// Exemplo: $page_title = "Meu Painel";
?>

<!DOCTYPE html>
<html lang="pt-br"> <!-- Alterado para português do Brasil -->
<head>
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) : "IBO Player v4.3 - Painel"; ?></title>
    <meta charset="utf-8" />
    <meta name="description" content="MaxRebrands IBO Panel" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo $static_url; ?>media/logos/logo.png" />

    <!-- Estilos globais do Metronic/Keenthemes (plugins e estilo principal) -->
    <link href="<?php echo $static_url; ?>plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo $static_url; ?>css/style.bundle.css" rel="stylesheet" type="text/css" />
    
    <!-- Fonte Roboto do Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

    <!-- Estilos CSS personalizados -->
    <style>
        body {
            font-family: 'Roboto', sans-serif !important;
            background-color: var(--bs-body-bg);
            margin: 0;
        }

        /* Estilo para cartões com design Material Design 3 */
        .card-md3 {
            border-radius: 24px;
            background-color: var(--bs-body-bg);
            box-shadow:
                0 2px 8px rgba(0, 0, 0, 0.1),
                0 1px 3px rgba(0, 0, 0, 0.06);
            padding: 2.5rem;
            transition: box-shadow 0.3s ease;
        }
        .card-md3:hover {
            box-shadow:
                0 4px 16px rgba(103, 80, 164, 0.24),
                0 8px 24px rgba(103, 80, 164, 0.12);
        }

        /* Estilo para campos de formulário */
        .form-control {
            border-radius: 12px !important;
            border: 1px solid #cfcfcf;
            padding: 0.8rem 1.2rem;
            background-color: var(--bs-body-bg) !important;
            color: var(--bs-body-color) !important;
            font-size: 1rem;
            font-weight: 400;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
            box-shadow: none;
        }
        .form-control::placeholder {
            color: #9e9e9e;
            opacity: 1;
        }
        .form-control:focus {
            border-color: #6750A4;
            box-shadow: 0 0 8px 0 rgba(103, 80, 164, 0.5);
            outline: none;
            background-color: var(--bs-body-bg);
        }

        /* Estilo para botões primários */
        .btn-primary {
            border-radius: 24px;
            padding: 0.75rem 1.5rem;
            background-color: #6750A4 !important;
            border-color: #6750A4 !important;
            font-weight: 600;
            font-size: 1.1rem;
            box-shadow:
                0 4px 8px rgba(103, 80, 164, 0.3);
            transition: background-color 0.3s ease, box-shadow 0.3s ease;
        }
        .btn-primary:hover, .btn-primary:focus {
            background-color: #5B42A1 !important;
            box-shadow:
                0 6px 12px rgba(103, 80, 164, 0.5);
        }
        .btn-primary:active {
            background-color: #4a3683 !important;
            box-shadow: none;
        }

        /* Estilo para o indicador de progresso (spinner) */
        .indicator-progress {
            font-size: 0.875rem;
            color: #999;
        }

        /* Estilo para a logo no formulário de login */
        img.h-200px {
            max-height: 200px; /* Definido para 200px para ser consistente */
            width: auto; /* Garante que a proporção seja mantida */
            filter: drop-shadow(0 2px 4px rgba(0,0,0,0.15));
        }

        /* Rodapé do tema (se aplicável ao layout completo) */
        #kt_app_sidebar_footer {
            user-select: none;
        }

        .theme-light-show, .theme-dark-show {
            font-weight: 600;
            font-size: 1.1rem;
        }

        /* Ajustes responsivos */
        @media (max-width: 991px) {
            .w-lg-500px {
                max-width: 100% !important;
                padding: 2rem !important;
            }
            .bgi-size-cover {
                min-height: 250px !important;
                background-position: center center !important;
            }
            h1.fs-2qx {
                font-size: 1.8rem !important;
            }
        }
    </style>
</head>
<body id="kt_body" class="app-blank">
    <!-- Script para controle de tema (light/dark mode) -->
    <script>
        var defaultThemeMode = "light"; 
        var themeMode;
        if (document.documentElement) {
            if (document.documentElement.hasAttribute("data-bs-theme-mode")) {
                themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
            } else {
                themeMode = localStorage.getItem("data-bs-theme") || defaultThemeMode;
            }

            if (themeMode === "system") {
                themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
            }
            document.documentElement.setAttribute("data-bs-theme", themeMode);
        }
    </script>
    <!-- Início do Root Element da Aplicação -->
    <div class="d-flex flex-column flex-root" id="kt_app_root">
        <div class="d-flex flex-column flex-lg-row flex-column-fluid">

            <!-- Coluna principal do formulário de login -->
            <div class="d-flex flex-column flex-lg-row-fluid w-lg-50 p-10 order-2 order-lg-1">
                <div class="d-flex flex-center flex-column flex-lg-row-fluid">
                    <div class="w-lg-500px card-md3">
                        <form class="form w-100" novalidate="novalidate" id="kt_sign_in_form" data-kt-redirect-url="index.html" action="#">
                            <div class="text-center mb-11 mt-4">
                                <img alt="Logo" src="<?php echo $static_url; ?>media/logos/logo.png" class="h-200px" />
                            </div>

                            <div class="fv-row mb-8">
                                <input type="text" placeholder="Username" name="username" autocomplete="off" class="form-control" />
                            </div>

                            <div class="fv-row mb-3">
                                <input type="password" placeholder="Password" name="password" autocomplete="off" class="form-control" />
                            </div>

                            <div class="d-grid mb-10">
                                <button type="submit" id="kt_sign_in_submit" class="btn btn-primary">
                                    <span class="indicator-label">ENTRAR</span>
                                    <span class="indicator-progress">Aguarde...
                                        <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- Fim da coluna principal do formulário de login -->

            <!-- Div para o conteúdo da direita (se houver, como uma imagem de fundo) -->
            <!-- Esta div estava faltando no seu código original, causando um erro de estrutura -->
            <!-- Exemplo de como poderia ser: -->
            <!-- <div class="d-flex flex-lg-row-fluid w-lg-50 bgi-size-cover bgi-position-center order-1 order-lg-2" style="background-image: url(<?php echo $static_url; ?>media/misc/auth-bg.png)"></div> -->

        </div>
    </div>

    <!-- Scripts JS globais do Metronic/Keenthemes -->
    <script src="<?php echo $static_url; ?>plugins/global/plugins.bundle.js"></script>
    <script src="<?php echo $static_url; ?>js/scripts.bundle.js"></script>
    
    <!-- Script JS específico para o formulário de login (se `users.js` lida com o login) -->
    <script src="<?php echo $static_url; ?>js/users.js"></script>
</body>
</html>