<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/includes/functions.php';
require_once 'session_check.php';

$page_title   = "QR Code URL";
$static_url   = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
$success_msg  = '';
$error_msg    = '';
$current_url  = '';
$current_label = '';

// Função para buscar dados do QR Code
function getQRCodeData($db) {
    $qr_data = $db->select('qr_code', '*', 'id = :id', '', [':id' => '1']);
    return (!empty($qr_data) && is_array($qr_data)) ? $qr_data[0] : [];
}

// Função para atualizar QR Code
function updateQRCode($db, $url, $label) {
    return $db->update('qr_code', ['url' => $url, 'name' => $label], 'id = :id', [':id' => '1']);
}

// Obtém dados atuais
$qr_code = getQRCodeData($db);
$current_url = $qr_code['url'] ?? '';
$current_label = $qr_code['name'] ?? '';

// Processa envio do formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $url  = trim(filter_input(INPUT_POST, 'web_url', FILTER_UNSAFE_RAW) ?? '');
    $name = trim(filter_input(INPUT_POST, 'web_label', FILTER_SANITIZE_FULL_SPECIAL_CHARS) ?? '');

    // Validação simples: aceita qualquer texto não vazio
    if (empty($url)) {
        $error_msg = "Please enter a valid URL or code.";
    } else {
        if (updateQRCode($db, $url, $name)) {
            $success_msg = "Data saved successfully!";
            $current_url = $url;
            $current_label = $name;
        } else {
            $error_msg = "Failed to save data. Please try again.";
        }
    }
}

ob_start();
?>

<div class="container mt-5">
    <div class="card mb-5 mb-xl-12">
        <div class="card-body py-12">
            <h2 class="mb-9">QR PAGAMENTOS</h2>

            <?php if ($success_msg): ?>
                <div class="alert alert-success"><?= htmlspecialchars($success_msg) ?></div>
            <?php endif; ?>

            <?php if ($error_msg): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error_msg) ?></div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="form-group mb-3">
                    <label for="web_url">QR Code Data:</label>
                    <input 
                        type="text"
                        class="form-control"
                        name="web_url"
                        id="web_url"
                        placeholder="Enter URL, PIX code, or any text"
                        value="<?= htmlspecialchars($current_url) ?>"
                        required>
                </div>

                <div class="form-group mb-3">
                    <label for="web_label">QR Label:</label>
                    <input 
                        type="text"
                        class="form-control"
                        name="web_label"
                        id="web_label"
                        placeholder="Ex: Payment PIX or Website Link"
                        value="<?= htmlspecialchars($current_label) ?>">
                </div>

                <div class="text-center mt-4">
                    <button type="submit" class="btn btn-primary btn-block">Save</button>
                </div>
            </form>

            <?php if (!empty($current_url)): ?>
            <div class="row mt-5">
                <div class="col-xl-12 text-center">
                    <h5 class="mb-3">QR Code Preview</h5>
                    <img src="https://api.qrserver.com/v1/create-qr-code/?data=<?= urlencode($current_url) ?>&size=200x200" alt="QR Code">
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
$page_content = ob_get_clean();
include 'includes/layout.php';
